/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class CaterKiller
extends EntityLiving {
    public CaterKiller(World w) {
        super(w);
        this.maxrenderdist = 260;
        this.height = 6.33f;
        this.width = 3.75f;
        this.uniquename = "OreSpawn:CaterKiller";
        this.moveSpeed = 0.31f;
        this.setMaxHealth(300.0f);
        this.setHealth(300.0f);
        this.setDefense(3.0f);
        this.setAttackDamage(40.0f);
        this.searchDistance = 28.0f;
        this.attackRange = 5.0f;
        this.movefrequency = 65;
        this.setExperience(499);
        this.canSwim = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.enable_findfoodblock = true;
        this.foodblockfreq = 50;
        this.foodblockdistxz = 16;
        this.foodblockdisty = 7;
        this.foodblockdisteat = 75;
        this.foodblockheal = 5;
        this.fooddaytimeonly = false;
        this.tower_defense_enable = true;
    }

    public void doEntityAction(float deltaT) {
        super.doEntityAction(deltaT);
        this.foodblockfreq = 50;
        if (this.getHealth() + 1.0f < this.getMaxHealth()) {
            this.foodblockfreq = 30;
        }
        if (this.getHealth() < this.getMaxHealth() / 2.0f) {
            this.foodblockfreq = 10;
        }
    }

    public void doDistanceAttack(Entity victim) {
        int m = 0;
        while (m < 3) {
            int px = (int)victim.posx + (this.world.rand.nextInt(3) - this.world.rand.nextInt(3));
            int py = (int)victim.posy;
            int pz = (int)victim.posz + (this.world.rand.nextInt(3) - this.world.rand.nextInt(3));
            int i = -5;
            while (i < 4) {
                int bid = this.world.getblock(this.dimension, px, py + i, pz);
                if (bid != 0 && (bid = this.world.getblock(this.dimension, px, py + i + 1, pz)) == 0) {
                    this.world.setblockWithPerm((Entity)this, this.dimension, px, py + i + 1, pz, Blocks.stickyblock.blockID);
                    break;
                }
                ++i;
            }
            ++m;
        }
    }

    public boolean isFoodBlock(int bid) {
        if (bid == Blocks.log.blockID || bid == Blocks.willowlog.blockID || bid == Blocks.redwoodlog.blockID) {
            return true;
        }
        if (bid == OreSpawnMain.MySkyTreeLog.blockID || bid == OreSpawnMain.MyDT.blockID) {
            return true;
        }
        if (bid == Blocks.leaves.blockID || bid == Blocks.willowleaves.blockID || bid == Blocks.redwoodleaves.blockID) {
            return true;
        }
        return bid == Blocks.appleleaves.blockID || bid == Blocks.cherryleaves.blockID || bid == Blocks.peachleaves.blockID;
    }

    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        int which = this.world.rand.nextInt(4);
        if (which == 0) {
            return "OreSpawn:caterkiller_living1";
        }
        if (which == 1) {
            return "OreSpawn:caterkiller_living2";
        }
        if (which == 2) {
            return "OreSpawn:caterkiller_living3";
        }
        return "OreSpawn:caterkiller_living4";
    }

    public String getHurtSound() {
        int which = this.world.rand.nextInt(4);
        if (which == 0) {
            return "OreSpawn:caterkiller_hit1";
        }
        if (which == 1) {
            return "OreSpawn:caterkiller_hit2";
        }
        if (which == 2) {
            return "OreSpawn:caterkiller_hit3";
        }
        return "OreSpawn:caterkiller_hit4";
    }

    public String getDeathSound() {
        return "OreSpawn:caterkiller_death";
    }

    public void doDeathDrops() {
        int howmany = 4 + this.world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosemeat.itemID, (float)5.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosebone.itemID, (float)5.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.lumptin.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 1 + this.world.rand.nextInt(3);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)Blocks.blocktin.blockID, (int)0, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.tinboots.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.tinleggings.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.tinchestplate.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.tinhelmet.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.tinaxe.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.tinpickaxe.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.tinshovel.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.tinsword.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.tinhoe.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophycaterkiller.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.caterkillerjaw.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        super.doDeathDrops();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof CaterKiller) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/CaterKillertexture.png");
        }
        return this.texture;
    }
}

